<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/ControlloreStringhe.php";
    include "../../../../classi/GeneratoreUrl.php";
    include "../../../../classi/Contenuto.php";
    include "../classi/ElementoPortfolio.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $elementoPortfolio = new ElementoPortfolio($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $elementoPortfolio = new ElementoPortfolio($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'modifica':
            $privato         = (isset($_POST["privato"]) && $_POST["privato"]=="si") ? "si" : "no";
            $mostraTitolo    = "no";
            $mostraNellaHome = "no";
            $abilitaCommenti = (isset($_POST["abilitaCommenti"]) && $_POST["abilitaCommenti"]=="si") ? "si" : "no";
            $categoria       = (isset($_POST["categoria"])) ? filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT) : "0";
            $descrizione     = (isset($_POST["descrizione"])) ? filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_STRING) : "";
            $testo           = (isset($_POST["testo"])) ? filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES) : "";
            
            $elementoPortfolio->caricaDatiDalDatabase();
            $elementoPortfolio->setTitolo(filter_input(INPUT_POST,"titolo",FILTER_SANITIZE_ADD_SLASHES));
            $elementoPortfolio->setMetaTitolo(filter_input(INPUT_POST,"metaTitolo",FILTER_SANITIZE_ADD_SLASHES));
            $elementoPortfolio->setMostraTitolo($mostraTitolo);
            $elementoPortfolio->setMostraNellaHome($mostraNellaHome);
            $elementoPortfolio->setCommenti($abilitaCommenti);
            $elementoPortfolio->setDescrizione($descrizione);
            $elementoPortfolio->setAlias(filter_input(INPUT_POST,"alias",FILTER_SANITIZE_STRING));
            $elementoPortfolio->setTipo("elementoPortfolio");
            $elementoPortfolio->setMetaDescrizione(filter_input(INPUT_POST,"metaDescrizione",FILTER_SANITIZE_STRING));
            $elementoPortfolio->setTesto($testo);
            $elementoPortfolio->setStato(filter_input(INPUT_POST,"stato",FILTER_SANITIZE_STRING));
            $elementoPortfolio->setTemplate(filter_input(INPUT_POST,"template",FILTER_SANITIZE_STRING));
            $elementoPortfolio->setEtichettaImmagine(filter_input(INPUT_POST,"etichettaImmagine",FILTER_SANITIZE_STRING));
            $elementoPortfolio->setCategoria($categoria);
            $elementoPortfolio->setCssGenerato($elementoPortfolio->cssGenerato());
            $elementoPortfolio->setCssAggiuntivo(filter_input(INPUT_POST,"cssAggiuntivo",FILTER_SANITIZE_STRING));
            $datiAnalisiSEO = $elementoPortfolio->eseguiAnalisiSeo();
            $elementoPortfolio->setPunteggioSeo($datiAnalisiSEO["esitoTesto"]);
            $elementoPortfolio->modifica();
            
            header("Location: ../creaElemento.php?id={$elementoPortfolio->getId()}&status=300");
            break;
        case 'stampaElencoImmagini':
            $elementoPortfolio->stampaImmaginiElemento();
            break;
        case 'spostaElemento':
            $elementoPortfolio->spostaInAltroPortfolio(filter_input(INPUT_GET, "idPortfolio",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$elementoPortfolio->getId()}&status=360");
            break;
        case 'duplicaInAltroPortfolio':
            $idNuovoELemento = $elementoPortfolio->duplicaInAltroPortfolio(filter_input(INPUT_GET, "idPortfolio",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoELemento}&status=370");
            break;
    }
